<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
class ProductController extends Controller
{
    public function ProductCheck($product_code = null, $productName = null){
        $setting = DB::table('seos')->first();
        return response()->json([
            'data'=>$productName,
            'title'=>$setting->home_title
        ]);
    }
    public function CatCheck($catName){
        $setting = DB::table('seos')->first();
        $cat_count = DB::table('extra_categories')->where(['cat_name'=>$catName])->count();
        if($cat_count > 0){
            $cat_name = DB::table('extra_categories')->where(['cat_name'=>$catName])->first();
            if($cat_name->cat_type == 'main_category_id'){
                $cat = DB::table('add_categories')->where(['id'=>$cat_name->cat_id])->first();
            }else if($cat_name->cat_type == 'sub_category_id'){
                $cat = DB::table('categories')->where(['id'=>$cat_name->cat_id])->first();
            }
            return response()->json([
                'data'=>$cat->category_name,
                'title'=>$setting->home_title
            ]);
        }else{
            return response()->json([
                'data'=>false,
                'title'=>$setting->home_title
            ]);
        }

    }
    public function RelatedProduct($productCode){
        $productCheck = DB::table('product_attributes')->where(['sku'=>$productCode])->select('id')->count();
        if($productCheck >0){
            $prod = DB::table('product_attributes')->where(['sku'=>$productCode])->select('product_id')->first();
            $category_id = DB::table('products')->where(['id'=>$prod->product_id])->select('category_id')->first();
        }else{
            $category_id = DB::table('products')->where(['code'=>$productCode])->select('category_id')->first();
        }
        $categoryProduct = DB::table('products')->where(['category_id'=>$category_id->category_id])->select('type','product_name','id','product_desc','description','stock','code','selling_price','lowest_price','highest_price','min_order')->get()->take(10);
        foreach($categoryProduct as $p){
            $productImages[] = DB::table('images')->where(['product_id'=>$p->id])->select('name')->first();
        }
        return response()->json([
            'product'=>$categoryProduct,
            'image'=>$productImages
        ]);
    }
    public function ProductDetailPage($productCode){
        $productFirstCount = DB::table('products')->where(['code'=>$productCode])->select('id')->count();
        if($productFirstCount == 0){
            return response()->json([
                'data'=>false,
            ]);
        }
        $productFirst = DB::table('products')->where(['code'=>$productCode])->select('video_url','type','product_name','id','product_desc','description','stock','code','selling_price','lowest_price','highest_price','min_order','category_id')->first();
        $product_leads = DB::table('product_leads')->where(['product_id'=>$productFirst->id])->select('name','value')->get();
        $product_specifications = DB::table('product_specifications')->where(['product_id'=>$productFirst->id])->select('name','value')->get();
        $productImages = DB::table('images')->where(['product_id'=>$productFirst->id])->select('name')->get();
        $productTermsConditions = DB::table('terms_conditions')->select('product_order_terms_condition')->first();
        if($productFirst->type == 'variable'){
            $product_color_variant = DB::table('product_attributes')->where(['product_id'=>$productFirst->id])->select('color','image')->get();
            $productSizes = DB::table('product_attributes')->where(['product_id'=>$productFirst->id])->where(['color'=>$product_color_variant[0]->color])->select('image','size')->get();
            return response()->json([
                'data'=>true,
                'product'=>$productFirst,
                'productVariant'=>$product_color_variant,
                'productLeads'=>$product_leads,
                'productSpecifications'=>$product_specifications,
                'productSizes'=>$productSizes,
                'productImages'=>$productImages,
                'productTermsConditions'=>$productTermsConditions
            ]);
        }else{
            
            return response()->json([
                'data'=>true,
                'product'=>$productFirst,
                'productLeads'=>$product_leads,
                'productSpecifications'=>$product_specifications,
                'productImages'=>$productImages,
                'productTermsConditions'=>$productTermsConditions
            ]);
        }
    }
    public function ProductDetailPageProductDetail($productId, $name){
        $productSizes = DB::table('product_attributes')->where(['product_id'=>$productId])->where(['color'=>$name])->select('image','size','selling_price','lowest_price','highest_price','stock','sku')->get();
        return response()->json([
            'productSizes'=>$productSizes,
        ]);
    }
    public function ProductWiseSizePrice(Request $request){
        $productSizes = DB::table('product_attributes')->where(['size'=>$request->size])->where(['product_id'=>$request->productId])->where(['color'=>$request->color])->select('image','size','selling_price','lowest_price','highest_price','stock','sku')->first();
        return response()->json([
            'productSizes'=>$productSizes,
        ]);
    }
    public function HotSellingProduct(){
        $products = DB::table('products')->orderBy('total_order','DESC')->select('type','product_name','id','product_desc','description','stock','code','selling_price','lowest_price','highest_price','min_order')->get()->take(10);
        foreach($products as $p){
            $productImages[] = DB::table('images')->where(['product_id'=>$p->id])->select('name')->first();
        }
        return response()->json([
            'hot_products'=>$products,
            'hot_productImages'=>$productImages
        ]);
    }
    public function AllCategoryProduct(){
        $products = [];
        $productImages = [];
        $categories = DB::table('add_categories')->where(['status'=>1])->select('id')->get();
        foreach($categories as $category){
            $categoryProducts = DB::table('products')
            ->where('category_id', $category->id)
            ->orderBy('id', 'DESC')
            ->select('category_id','type', 'product_name', 'id', 'product_desc', 'description', 'stock', 'code', 'selling_price', 'lowest_price', 'highest_price', 'min_order')
            ->where('stock','==',0)
            ->take(4) // এখানেই limit নিচ্ছি
            ->get();

        foreach ($categoryProducts as $product) {
            $products[] = $product;

            // product_id দিয়ে প্রথম ইমেজ (যদি থাকে) নিয়ে নিচ্ছি
            $image = DB::table('images')
                ->where('product_id', $product->id)
                ->select('name')
                ->first();

            $productImages[] = $image ? $image->name : null;
        }
        }
        return response()->json([
            'CategoryAllproducts'=>$products,
            'CategoryAllproductImages'=>$productImages
        ]);
    }
    public function SamplePageProduct(){
        $categories = DB::table('add_categories')->where(['status'=>1])->select('id','category_name')->get();
        return response()->json([
            'categories'=>$categories
        ]);
    }
    public function SamplePageProductCategory($id){
            $categoryProducts = DB::table('products')
            ->leftJoin(DB::raw("(SELECT MIN(id) as id, product_id FROM images GROUP BY product_id) as first_images"),
                'products.id', '=', 'first_images.product_id'
            )
            ->leftJoin('images', 'images.id', '=', 'first_images.id')
            ->where('category_id', $id)
            ->orderBy('id', 'DESC')
            ->select(
                'products.id',
                'products.category_id',
                'products.type',
                'products.product_name',
                'products.product_desc',
                'products.description',
                'products.stock',
                'products.code',
                'products.selling_price',
                'products.lowest_price',
                'products.highest_price',
                'products.min_order',
                'images.name as product_image'
            )
            ->where('stock','==',0)
            ->paginate(8);
        return response()->json([
            'categoryProducts'=>$categoryProducts
        ]);
    }
    public function OrderDetails($id){
        $order = DB::table('orders')->where(['id'=>$id])->first();
        $order->status = match($order->status) {
                1 => 'Approved',
                2 => 'New Order',
                3 => 'Shipment',
                4 => 'Cancel',
                5 => 'Authorized',
                6 => 'Delivered',
                8 => 'Pending',
                default => 'Unknown'
            };
            $order->date_time = date('d M Y h:i a', strtotime($order->date_time));
            $order->approved_by_date_time = date('d M Y h:i a', strtotime($order->approved_by_date_time));
            $order->shipped_by_date_time = date('d M Y h:i a', strtotime($order->shipped_by_date_time));
            $order->delivered_by_date_time = date('d M Y h:i a', strtotime($order->delivered_by_date_time));
            $order->authorized_by_date_time = date('d M Y h:i a', strtotime($order->authorized_by_date_time));
        $order_attribute = DB::table('order_products')->where(['order_id'=>$id])->get();
        return response()->json([
            'order'=>$order,
            'order_products'=>$order_attribute
        ]);
    }
}
