<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
use App\Models\Cart;

class CartController extends Controller
{
    public function CartItem($session){
        $authTokenID = DB::table('personal_access_tokens')->where(['id'=>$session])->select('tokenable_id')->first();
        if($authTokenID){
            $userId = DB::table('users')->where(['id'=>$authTokenID->tokenable_id])->select('id')->first();
            $cartItem = DB::table('carts')->where(['user_id'=>$userId->id])->get();
            $compareItem = DB::table('compares')->where(['user_id'=>$userId->id])->get();
            $cartcount = DB::table('carts')->where(['user_id'=>$userId->id])->sum('total_price');
        }else{
            $cartItem = DB::table('carts')->where(['session_id'=>$session])->get();
            $compareItem = DB::table('compares')->where(['session_id'=>$session])->get();
            $cartcount = DB::table('carts')->where(['session_id'=>$session])->sum('total_price');
        }
        // $settings = DB::table('settings')->first();
        return response()->json([
            'cartItem'=>$cartItem,
            'compareItem'=>$compareItem,
            'cartcount'=>$cartcount,
            // 'settings'=>$settings
        ]);
    }
    public function AddtoCartPost($quantity, $productId, $productCode, $token){
        $authTokenID = DB::table('personal_access_tokens')->where(['id'=>$token])->select('tokenable_id')->first();
        // return $authTokenID;
        $productAttributeCodeCheck = DB::table('product_attributes')->where(['sku'=>$productCode])->select('id')->count();
        if($authTokenID){
            $userId = DB::table('users')->where(['id'=>$authTokenID->tokenable_id])->select('id')->first();
            $cart_count = DB::table('carts')->where(['product_code'=>$productCode])->where(['user_id'=>$userId->id])->count();
        }else{
            $cart_count = DB::table('carts')->where(['product_code'=>$productCode])->where(['session_id'=>$token])->count();
        }
        $productCodeCheck = DB::table('products')->where(['code'=>$productCode])->select('id')->count();
        if($productCodeCheck > 0){
            $product = DB::table('products')->where(['code'=>$productCode])->select('selling_price','id')->first();
            $productName = DB::table('products')->where(['id'=>$productId])->select('product_name')->first();
            $productImage = DB::table('images')->where(['product_id'=>$product->id])->orderBy('id','ASC')->select('name')->first()->name;
        }else{
            if($productAttributeCodeCheck > 0){
                $product = DB::table('product_attributes')->where(['sku'=>$productCode])->select('selling_price','color','size')->first();
                $productImage = DB::table('product_attributes')->where(['sku'=>$productCode])->select('image')->first()->image;
                $productName = DB::table('products')->where(['id'=>$productId])->select('product_name')->first();
            }else{
                return response()->json([
                    'success'=>false,
                    'message'=>'No product.'
                ]);
            }
        }

        if($cart_count < 1){
            $cart = new Cart;
            if($authTokenID){
                $cart->user_id = $userId->id;
            }else{
                $cart->session_id = $token;
            }
            if($productAttributeCodeCheck > 0){
                $cart->product_size = $product->size;
                $cart->product_color = $product->color;
            }
            $cart->product_name = $productName->product_name;
            $cart->product_code = $productCode;
            $cart->product_image = $productImage;
            $cart->product_price = $product->selling_price;
            $cart->quantity = $quantity;
            $cart->total_price = $product->selling_price*$quantity;
            $cart->save();
            $carts = DB::getPdo()->lastInsertId();
            return response()->json([
                'data'=>$cart,
                'success'=>true,
                'message'=>'Successfully Added',
            ]);
        }else{
            return response()->json([
                'success'=>false,
                'message'=>'Already Added!',
            ]);
        }
    }
    public function CartQuantityUpdate($quantity, $id){
        $cartPrice = DB::table('carts')->where(['id'=>$id])->select('product_price')->first();
        DB::table('carts')->where(['id'=>$id])->update(['quantity'=>$quantity,'total_price'=>$cartPrice->product_price*$quantity]);
    }
    public function DeleteCartItem($id){
        DB::table('carts')->where(['id'=>$id])->delete();
    }
    public function CartQuantityCheck($productCode){
        $productCodeCheck = DB::table('products')->where(['code'=>$productCode])->select('id')->count();
        if($productCodeCheck > 0){
            $product = DB::table('products')->where(['code'=>$productCode])->select('id','stock')->first();
            $productMinOrder = DB::table('products')->where(['code'=>$productCode])->select('min_order')->first();
        }else{
            $product = DB::table('product_attributes')->where(['sku'=>$productCode])->select('stock','product_id')->first();
            $productMinOrder = DB::table('products')->where(['id'=>$product->product_id])->select('min_order')->first();
        }
        return response()->json([
            'success'=>true,
            'product'=>$product,
            'productMinOrder'=>$productMinOrder
        ]);
    }
}
