<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PageController;
use App\Http\Controllers\api\PathaoController;
// Route::get('/{pathMatch}',function(){
//     return view('welcome');
// })->where('pathMatch',".*");

// Route::get('/', function () {
//     return view('welcome');
// });


Route::match(['get','post'], '/',[PageController::class, 'home']);
Route::match(['get','post'], '/test',[PageController::class, 'home']);
Route::match(['get','post'], '/samples',[PageController::class, 'home']);
Route::match(['get','post'], '/in-stock',[PageController::class, 'home']);
// Route::match(['get','post'], '/{pathMatch}',[PageController::class, 'patchMatch'])->where('pathMatch',".*");
Route::match(['get','post'], '/order/order-confirmation/{orderId}',[PageController::class, 'orderConfirmation']);
Route::match(['get','post'], '/products',[PageController::class, 'shop']);
Route::match(['get','post'], '/products/{productId}/{productName}',[PageController::class, 'productDetails']);
Route::match(['get','post'], '/carts',[PageController::class, 'cart']);
Route::match(['get','post'], '/payment/{paymentName}/{orderId}',[PageController::class, 'payment']);
Route::match(['get','post'], '/payment/{paymentName}/{orderId}/{amount}',[PageController::class, 'custom_payment']);
Route::match(['get','post'], '/login',[PageController::class, 'login']);
Route::match(['get','post'], '/forgot-password',[PageController::class, 'forgot_password']);
Route::match(['get','post'], '/register',[PageController::class, 'register']);
Route::match(['get','post'], '/payment-history',[PageController::class, 'payment_history']);
Route::match(['get','post'], '/orders',[PageController::class, 'orders']);
Route::match(['get','post'], '/customer/profile',[PageController::class, 'profile']);
Route::match(['get','post'], '/about-us',[PageController::class, 'about']);
Route::match(['get','post'], '/contact-us',[PageController::class, 'contact']);
Route::match(['get','post'], '/company-profile',[PageController::class, 'CompanyProfile']);
Route::match(['get','post'], '/faq',[PageController::class, 'faq']);
Route::match(['get','post'], '/privacy-policy',[PageController::class, 'privacy_policy']);
Route::match(['get','post'], '/team',[PageController::class, 'team']);
Route::match(['get','post'], '/terms-and-conditions',[PageController::class, 'terms_condition']);
Route::match(['get','post'], '/search/{searchText}',[PageController::class, 'SearchProduct']);
Route::match(['get','post'], '/checkout',[PageController::class, 'checkout']);
// Route::match(['get','post'], '/verify-phone/{phoneNo}/{token}',[PageController::class, 'home']);
// Update Page
Route::match(['get','post'], 'category/{categoryName}',[PageController::class, 'ViewCategory']);
Route::match(['get','post'], 'category/{categoryName}/{subCategory}',[PageController::class, 'ViewSubCategory']);
Route::match(['get','post'], '/quote-form/{productId}',[PageController::class, 'QuoteForm']);
Route::match(['get','post'], '/quote-form',[PageController::class, 'QuoteFormN']);
Route::match(['get','post'], '/order-success/{id}',[PageController::class, 'OrderSuccess']);
Route::match(['get','post'], '//user/dashboard',[PageController::class, 'UserDashboard']);




// Route::match(['get','post'], '/{categoryProduct}',[PageController::class, 'categoryProduct']);

Route::match(['get','post'], '/pathao-courier-test',[PathaoController::class, 'PathaoCourierTest']);
Route::match(['get','post'], '/total-order/{userId}',[\App\Http\Controllers\api\UserController::class, 'TotalOrder']);
Route::match(['get','post'], '/login-post/{phone}/{password}/{session}',[\App\Http\Controllers\api\AuthController::class, 'Login'])->name('Login');
Route::match(['get','post'], '/setting-get',[\App\Http\Controllers\api\HomeController::class, 'settingGet'])->name('settingGet');
Route::match(['get','post'], '/auth-user-check-account-information',[\App\Http\Controllers\api\UserController::class, 'AuthUserCheckAccountInformation']);
Route::match(['get','post'], '/update-user-account',[\App\Http\Controllers\api\UserController::class, 'UpdateUserAccount']);
Route::match(['get','post'], '/dashboard-page-data',[\App\Http\Controllers\api\UserController::class, 'DashboardPageData']);
Route::match(['get','post'], '/change-password-user',[\App\Http\Controllers\api\UserController::class, 'ChangePassword']);
Route::match(['get','post'], '/user-logout',[\App\Http\Controllers\api\UserController::class, 'UserLogout'])->name('UserLogout');   

Route::get('/customer-location', function () {
    return view('map.customer_location');
});
Route::get('/all-order-check', function () {
    return view('map.all_order_check');
});
Route::get('/all-order-check-details', function () {
    return view('map.all_order_check_details');
});