<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Order Location Map (FREE)</title>

    <!-- Leaflet CSS (FREE) -->
    <link
        rel="stylesheet"
        href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css"
    />

    <style>
        body {
            font-family: Arial, sans-serif;
        }
        #map {
            height: 1200px;
            width: 100%;
            border: 1px solid #ccc;
        }
    </style>
</head>
<body>

<h2 style="text-align:center;margin:10px 0">
    📍 Customer Order Locations (100% FREE)
</h2>

<div id="map"></div>

<!-- Leaflet JS (FREE) -->
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>

<script>
    // 🔹 Demo Order Locations (Bangladesh)
    const locations = [
        { lat: 22.686308, lng: 90.641268, name:'Rohim', },
        { lat: 22.687981, lng: 90.645210, name:'Kajol', },
        { lat: 22.683494, lng: 90.640484, name:'Korimon', },
        { lat: 22.683447, lng: 90.643992, name:'Rubel', },
        { lat: 22.683929, lng: 90.648228, name:'Rabbi', },
        { lat: 22.688414, lng: 90.643252, name:'Rubina Khan', },
        { lat: 22.679479, lng: 90.646016, name:'Kamrul Islam', },
        { lat: 22.687531, lng: 90.652038, name:'Rabbi Islam', },
        { lat: 22.681975, lng: 90.644740, name:'Rohim', },
        { lat: 22.680068, lng: 90.642240, name:'Rubel', },
        { lat: 22.695655, lng: 90.652202, name:'Rina Akter', },
        // { lat: 23.8103, lng: 90.4125 },
        // { lat: 23.8103, lng: 90.4125 },
        // { lat: 23.8103, lng: 90.4125 },
        // { lat: 23.8103, lng: 90.4125 },
        // { lat: 23.8103, lng: 90.4125 },
        // { lat: 23.8103, lng: 90.4125 },
    ];

    // 🗺️ Map Init (Bangladesh Center)
    const map = L.map('map').setView([22.683410, 90.645748], 15);

    // 🟢 OpenStreetMap Tile (FREE forever)
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '© OpenStreetMap contributors'
    }).addTo(map);

    // 📍 Marker Add
    locations.forEach((loc, index) => {
        L.marker([loc.lat, loc.lng]).addTo(map)
            .bindPopup(`
                <b>Order #${index + 1}</b><br>
                Customer Name: ${loc.name}<br>
                Total Order: ${loc.lat}<br>
                Order Count: ${loc.lat}<br>
                Lng: ${loc.lng}<br>
                <a target="_blank"
                   href="https://www.google.com/maps?q=${loc.lat},${loc.lng}">
                   Navigate
                </a>
            `);
    });
</script>

</body>
</html>
<?php /**PATH C:\xampp\htdocs\amar bhola shop\resources\views/map/all_order_check.blade.php ENDPATH**/ ?>