<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;

class PageController extends Controller
{
    public function home(){
        $setting = DB::table('settings')->select('frontend_img_url','favicon','web_name','app_name','site_logo','color')->first();
        $seo = DB::table('seos')->select('keywords','home_title','site_meta_description')->first();
        return view('welcome', compact('setting','seo'));
    }
    public function shop(){
        $setting = DB::table('settings')->select('frontend_img_url','favicon','web_name','app_name','site_logo','color')->first();
        $seo = DB::table('seos')->select('keywords','home_title','site_meta_description')->first();
        return view('shop', compact('setting','seo'));
    }
    // public function patchMatch(){
    //     $setting = DB::table('settings')->first();
    //     $seo = DB::table('seos')->first();
    //     return view('welcome', compact('setting','seo'));
    // }
    public function orderConfirmation(){
        $setting = DB::table('settings')->select('frontend_img_url','favicon','web_name','app_name','site_logo','color')->first();
        $seo = DB::table('seos')->select('keywords','home_title','site_meta_description')->first();
        return view('orderConfirmation', compact('setting','seo'));
    }
    public function productDetails($productId, $productName){
        $setting = DB::table('settings')->select('frontend_img_url','favicon','web_name','app_name','site_logo','color')->first();
        $seo = DB::table('seos')->select('keywords','home_title','site_meta_description')->first();
        $product = DB::table('products')->where(['code'=>$productId])->select('product_name','id')->first();
        $productImage = DB::table('images')->where(['product_id'=>$product->id])->select('name')->first();
        return view('productDetails', compact('setting','seo', 'product','productImage'));
    }
    public function cart(){
        $setting = DB::table('settings')->select('frontend_img_url','favicon','web_name','app_name','site_logo','color')->first();
        $seo = DB::table('seos')->select('keywords','home_title','site_meta_description')->first();
        return view('cart', compact('setting','seo'));
    }
    public function payment(){
        $setting = DB::table('settings')->select('frontend_img_url','favicon','web_name','app_name','site_logo','color')->first();
        $seo = DB::table('seos')->select('keywords','home_title','site_meta_description')->first();
        return view('payment', compact('setting','seo'));
    }
    public function custom_payment(){
        $setting = DB::table('settings')->select('frontend_img_url','favicon','web_name','app_name','site_logo','color')->first();
        $seo = DB::table('seos')->select('keywords','home_title','site_meta_description')->first();
        return view('custom_payment', compact('setting','seo'));
    }
    public function login(){
        $setting = DB::table('settings')->select('frontend_img_url','favicon','web_name','app_name','site_logo','color')->first();
        $seo = DB::table('seos')->select('keywords','home_title','site_meta_description')->first();
        return view('login', compact('setting','seo'));
    }
    public function forgot_password(){
        $setting = DB::table('settings')->select('frontend_img_url','favicon','web_name','app_name','site_logo','color')->first();
        $seo = DB::table('seos')->select('keywords','home_title','site_meta_description')->first();
        return view('forgot_password', compact('setting','seo'));
    }
    public function register(){
        $setting = DB::table('settings')->select('frontend_img_url','favicon','web_name','app_name','site_logo','color')->first();
        $seo = DB::table('seos')->select('keywords','home_title','site_meta_description')->first();
        return view('register', compact('setting','seo'));
    }
    public function payment_history(){
        $setting = DB::table('settings')->select('frontend_img_url','favicon','web_name','app_name','site_logo','color')->first();
        $seo = DB::table('seos')->select('keywords','home_title','site_meta_description')->first();
        return view('payment_history', compact('setting','seo'));
    }
    public function orders(){
        $setting = DB::table('settings')->select('frontend_img_url','favicon','web_name','app_name','site_logo','color')->first();
        $seo = DB::table('seos')->select('keywords','home_title','site_meta_description')->first();
        return view('orders', compact('setting','seo'));
    }
    public function profile(){
        $setting = DB::table('settings')->select('frontend_img_url','favicon','web_name','app_name','site_logo','color')->first();
        $seo = DB::table('seos')->select('keywords','home_title','site_meta_description')->first();
        return view('profile', compact('setting','seo'));
    }
    public function about(){
        $setting = DB::table('settings')->select('frontend_img_url','favicon','web_name','app_name','site_logo','color')->first();
        $seo = DB::table('seos')->select('keywords','home_title','site_meta_description')->first();
        return view('about', compact('setting','seo'));
    }
    public function contact(){
        $setting = DB::table('settings')->select('frontend_img_url','favicon','web_name','app_name','site_logo','color')->first();
        $seo = DB::table('seos')->select('keywords','home_title','site_meta_description')->first();
        return view('contact', compact('setting','seo'));
    }
    public function faq(){
        $setting = DB::table('settings')->select('frontend_img_url','favicon','web_name','app_name','site_logo','color')->first();
        $seo = DB::table('seos')->select('keywords','home_title','site_meta_description')->first();
        return view('faq', compact('setting','seo'));
    }
    public function privacy_policy(){
        $setting = DB::table('settings')->select('frontend_img_url','favicon','web_name','app_name','site_logo','color')->first();
        $seo = DB::table('seos')->select('keywords','home_title','site_meta_description')->first();
        return view('privacy_policy', compact('setting','seo'));
    }
    public function terms_condition(){
        $setting = DB::table('settings')->select('frontend_img_url','favicon','web_name','app_name','site_logo','color')->first();
        $seo = DB::table('seos')->select('keywords','home_title','site_meta_description')->first();
        return view('terms_condition', compact('setting','seo'));
    }
    public function team(){
        $setting = DB::table('settings')->select('frontend_img_url','favicon','web_name','app_name','site_logo','color')->first();
        $seo = DB::table('seos')->select('keywords','home_title','site_meta_description')->first();
        return view('team', compact('setting','seo'));
    }
    public function SearchProduct($searchName){
        $setting = DB::table('settings')->select('frontend_img_url','favicon','web_name','app_name','site_logo','color')->first();
        $seo = DB::table('seos')->select('keywords','home_title','site_meta_description')->first();
        return view('SearchProduct', compact('setting','seo', 'searchName'));
    }
    public function checkout(){
        $setting = DB::table('settings')->select('frontend_img_url','favicon','web_name','app_name','site_logo','color')->first();
        $seo = DB::table('seos')->select('keywords','home_title','site_meta_description')->first();
        return view('checkout', compact('setting','seo'));
    }
    public function categoryProduct($catName){
        $setting = DB::table('settings')->select('frontend_img_url','favicon','web_name','app_name','site_logo','color')->first();
        $seo = DB::table('seos')->select('keywords','home_title','site_meta_description')->first();
        $cat_count = DB::table('extra_categories')->where(['cat_name'=>$catName])->count();
        if($cat_count > 0){
            $cat_name = DB::table('extra_categories')->where(['cat_name'=>$catName])->first();
            if($cat_name->cat_type == 'main_category_id'){
                $cat = DB::table('add_categories')->where(['id'=>$cat_name->cat_id])->first();
            }else if($cat_name->cat_type == 'sub_category_id'){
                $cat = DB::table('categories')->where(['id'=>$cat_name->cat_id])->first();
            }
            return view('categoryProduct', compact('setting','seo','cat_name','cat'));
        }else{
            return view('welcome', compact('setting','seo'));
        }
    }
    // Update Code
    public function ViewCategory(){
        $setting = DB::table('settings')->select('frontend_img_url','favicon','web_name','app_name','site_logo','color')->first();
        $seo = DB::table('seos')->select('keywords','home_title','site_meta_description')->first();
        return view('welcome', compact('setting','seo'));
    }
    public function ViewSubCategory(){
        $setting = DB::table('settings')->select('frontend_img_url','favicon','web_name','app_name','site_logo','color')->first();
        $seo = DB::table('seos')->select('keywords','home_title','site_meta_description')->first();
        return view('welcome', compact('setting','seo'));
    }
    public function allPage($tableName){
        $about = DB::table($tableName)->first();
        return response()->json([
            'data'=>$about,
        ]);
    }
    public function teamMember(){
        $teamMember = DB::table('users')->where(['team'=>1])->get();
        return response()->json([
            'data'=>$teamMember,
        ]);
    }
    public function contactpagesendmessage(Request $request){
        $table = new ContactPageMessage;
        $table->name = $request->name;
        $table->email = $request->email;
        $table->phone = $request->phone;
        $table->message = $request->message;
        $table->save();
        return response()->json([
            'success'=>true,
            'message'=>$table,
        ]);
    }
    public function QuoteForm($productId){
        $setting = DB::table('settings')->select('frontend_img_url','favicon','web_name','app_name','site_logo','color')->first();
        $seo = DB::table('seos')->select('keywords','home_title','site_meta_description')->first();
        return view('welcome', compact('setting','seo'));
    }
    public function QuoteFormN(){
        $setting = DB::table('settings')->select('frontend_img_url','favicon','web_name','app_name','site_logo','color')->first();
        $seo = DB::table('seos')->select('keywords','home_title','site_meta_description')->first();
        return view('welcome', compact('setting','seo'));
    }
    public function OrderSuccess(){
        $setting = DB::table('settings')->select('frontend_img_url','favicon','web_name','app_name','site_logo','color')->first();
        $seo = DB::table('seos')->select('keywords','home_title','site_meta_description')->first();
        return view('welcome', compact('setting','seo'));
    }
    
}
