<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
use Illuminate\Support\Str;
use Carbon\Carbon;
use App\Models\User;
use App\Models\Order;
use App\Models\OrderProduct;
use Hash;
use Storage;
class CheckoutController extends Controller
{
    public function CheckOutPage($session){
        // $cart =
        $authTokenID = DB::table('personal_access_tokens')->where(['id'=>$session])->select('tokenable_id')->first();
        $userId = null;
        if($authTokenID){
            $userId = DB::table('users')->where(['id'=>$authTokenID->tokenable_id])->select('id','name','company_name','email','phone','address')->first();
            $cartItem = DB::table('carts')->where(['user_id'=>$userId->id])->get();
        }else{
            $cartItem = DB::table('carts')->where(['session_id'=>$session])->get();
        }
        foreach($cartItem as $key=>$c){
            $productCheck = DB::table('products')->where(['code'=>$c->product_code])->select('id')->count();
            if($productCheck > 0){
                $CartMinimumStock[] = DB::table('products')->where(['code'=>$c->product_code])->select('stock')->first();
                $CartMinimumOrder[] = DB::table('products')->where(['code'=>$c->product_code])->select('min_order')->first();
                $productWeight[] = DB::table('products')->where(['code'=>$c->product_code])->select('weight')->first();
            }else{
                $CartMinimumStock[] = DB::table('product_attributes')->where(['sku'=>$c->product_code])->select('stock','product_id')->first();
                $CartMinimumOrder[] = DB::table('products')->where(['id'=>$CartMinimumStock[$key]->product_id])->select('min_order')->first();
                $productWeight[] = DB::table('products')->where(['id'=>$CartMinimumStock[$key]->product_id])->select('weight')->first();
            }
        }
        return response()->json([
            'CartMinimumOrder'=>$CartMinimumOrder,
            'CartMinimumStock'=>$CartMinimumStock,
            'productWeight'=>$productWeight,
            'user'=>$userId,
        ]);
    }
    public function AddOrderCheckout(Request $request, $session){
        // $authTokenID = DB::table('personal_access_tokens')->where(['id'=>$session])->select('tokenable_id')->first();
        // if($authTokenID){
        //     $userId = DB::table('users')->where(['id'=>$authTokenID->tokenable_id])->select('id','due_amount')->first();
        // }else{
        //     $user = new User;
        //     $user->phone = $request->customer_phone_no;
        //     $user->name = $request->customer_name;
        //     $user->email = $request->email;
        //     $user->address = $request->address;
        //     $user->password = Hash::make(Str::random(10));
        //     $user->save();
        //     DB::table('carts')->where(['session_id'=>$session])->update(['user_id'=>$user->id]);
        //     $userId = $user;
        // }
        $userCheck = DB::table('users')->where(['phone'=>$request->customer_phone_no])->count();
        if($userCheck == 0){
            $user = new User;
            $user->phone = $request->customer_phone_no;
            $user->name = $request->customer_name;
            $user->email = $request->email;
            $user->address = $request->address;
            $user->password = Hash::make(Str::random(10));
            $user->save();
            DB::table('carts')->where(['session_id'=>$session])->update(['user_id'=>$user->id]);
            DB::table('compares')->where(['session_id'=>$session])->update(['user_id'=>$user->id]);
            $userId = $user;
        }else{
            $userId =DB::table('users')->where(['phone'=>$request->customer_phone_no])->select('id','due_amount')->first();
        }
        $cartTotalPrice = DB::table('carts')->where(['user_id'=>$userId->id])->sum('total_price');
        $order = new Order;
        $order->order_type = 'customers';
        $order->order_type = 'users';
        $order->user_id = $userId->id;
        $order->customer_phone_no = $request->customer_phone_no;
        $order->customer_name = $request->customer_name;
        $order->sub_amount = $cartTotalPrice;
        $requestVat = DB::table('settings')->select('vat')->first();
        $order->vat = $cartTotalPrice*($requestVat->vat*(1/100));
        $order->shipping_charge = $request->shipping;
        $order->total_amount = ($order->sub_amount)+$order->vat+$order->shipping_charge;
        $order->created_by = $userId->id;
        $order->method = $request->method;
        $order->customer_address = $request->address;
        if($userId->due_amount){
            $order->due_amount = $userId->due_amount + $order->total_amount;
        }
        if($request->image){
            $img_path = 'image/checkout_file/'.''.$request->company_name.''.$request->fileName;
            Storage::disk('public')->put($img_path, file_get_contents($request->image));
            $order->image = $request->company_name.''.$request->fileName;
        }
        $order->notes = $request->note;
        $order->date_time = Carbon::now()->format('Y-m-d g:i A');
        $order->status = 2;
        $order->save();
        $cartAll = DB::table('carts')->where(['user_id'=>$userId->id])->select('product_code','product_image','product_name','product_color','product_size','quantity','product_price')->get();
        foreach($cartAll as $key=> $j){
            $manufactureOrderProduct = new OrderProduct;
            $manufactureOrderProduct->order_id =$order->id;
            $manufactureOrderProduct->status = $order->status;
            $manufactureOrderProduct->sku = $j->product_code;
            $manufactureOrderProduct->image = $j->product_image;
            $manufactureOrderProduct->product_name = $j->product_name;
            $manufactureOrderProduct->color = $j->product_color;
            $manufactureOrderProduct->size = $j->product_size;
            $manufactureOrderProduct->quantity = $j->quantity;
            $manufactureOrderProduct->price = $j->product_price;
            $manufactureOrderProduct->total_price = $j->quantity*$j->product_price;
            $manufactureOrderProduct->save();
            
        }
        DB::table('carts')->where(['user_id'=>$userId->id])->delete();
        return response()->json([
            'order'=>$order,
        ]);
    }
    public function OrderSuccessPageData($token, $id){
        $order = DB::table('orders')->where(['id'=>$id])->select('date_time','sub_amount')->first();
        $product = DB::table('order_products')->where(['order_id'=>$id])->select('product_name','sku','image','size','color','quantity','price','total_price')->get();
        return response()->json([
            'data'=>$product,
            'order'=>$order
        ]);
    }
}
