<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Compare;
use DB;
class CompareController extends Controller
{
    public function AddComparePost($productCode, $token){
        $authTokenID = DB::table('personal_access_tokens')->where(['id'=>$token])->select('tokenable_id')->first();
        if($authTokenID){
            $userId = DB::table('users')->where(['id'=>$authTokenID->tokenable_id])->select('id')->first();
            $cart_count = DB::table('compares')->where(['user_id'=>$userId->id])->where(['product_code'=>$productCode])->count();
        }else{
            $cart_count = DB::table('compares')->where(['session_id'=>$token])->where(['product_code'=>$productCode])->count();
        }
        if($cart_count == 0){
            $compare = new Compare;
            if($authTokenID){
                $compare->user_id = $userId->id;
            }else{
                $compare->session_id = $token;
            }
            $compare->product_code = $productCode;
            $compare->save();
            return response()->json([
                'success'=>true,
                'data'=>$compare
            ]);
        }
        
    }
    public function AllCompareGet($token){
        $authTokenID = DB::table('personal_access_tokens')->where(['id'=>$token])->select('tokenable_id')->first();
        if($authTokenID){
            $userId = DB::table('users')->where(['id'=>$authTokenID->tokenable_id])->select('id')->first();
            $compareCart = DB::table('compares')->where(['user_id'=>$userId->id])->select('product_code')->get();
            $compareCount = DB::table('compares')->where(['user_id'=>$userId->id])->select('product_code')->count();
        }else{
            $compareCart = DB::table('compares')->where(['session_id'=>$token])->select('product_code')->get();
            $compareCount = DB::table('compares')->where(['session_id'=>$token])->select('product_code')->count();
        }
        if($compareCount == 0){
            return response()->json([
                'success'=>false,
            ]);
        }
        $product =[];
        $minOrder =[];
        foreach($compareCart as $key=> $c){
            $productCheck = DB::table('products')->where(['code'=>$c->product_code])->count();
            if($productCheck > 0){
                $product[] = DB::table('products')->where(['code'=>$c->product_code])->select('highest_price','lowest_price','id')->first();
                $minOrder[] = DB::table('products')->where(['id'=>$product[$key]->id])->select('min_order')->first();
                $productSpecification[] = DB::table('product_specifications')->where(['product_id'=>$product[$key]->id])->get();
                $productImage[] = DB::table('images')->where(['product_id'=>$product[$key]->id])->select('name')->first();
                $productName[] = DB::table('products')->where(['id'=>$product[$key]->id])->select('product_name')->first();
            }else{
                $product[] = DB::table('product_attributes')->where(['sku'=>$c->product_code])->select('highest_price','lowest_price','product_id')->first();
                $minOrder[] = DB::table('products')->where(['id'=>$product[$key]->product_id])->select('min_order')->first();
                $productSpecification[] = DB::table('product_specifications')->where(['product_id'=>$product[$key]->product_id])->get();
                $productImage[] = DB::table('product_attributes')->where(['sku'=>$c->product_code])->select('image')->first();
                $productName[] = DB::table('products')->where(['id'=>$product[$key]->product_id])->select('product_name')->first();
            }
        }
        return response()->json([
            'success'=>true,
            'product'=>$product,
            'minOrder'=>$minOrder,
            'productSpecification'=>$productSpecification,
            'productImage'=>$productImage,
            'productName'=>$productName
        ]);
    }
    public function DeleteCompare($id){
        DB::table('compares')->where(['id'=>$id])->delete();
    }
}
