<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
class ProductController extends Controller
{
    public function ProductCheck($product_code = null, $productName = null){
        $setting = DB::table('seos')->first();
        return response()->json([
            'data'=>$productName,
            'title'=>$setting->home_title
        ]);
    }
    public function CatCheck($catName){
        $setting = DB::table('seos')->first();
        $cat_count = DB::table('extra_categories')->where(['cat_name'=>$catName])->count();
        if($cat_count > 0){
            $cat_name = DB::table('extra_categories')->where(['cat_name'=>$catName])->first();
            if($cat_name->cat_type == 'main_category_id'){
                $cat = DB::table('add_categories')->where(['id'=>$cat_name->cat_id])->first();
            }else if($cat_name->cat_type == 'sub_category_id'){
                $cat = DB::table('categories')->where(['id'=>$cat_name->cat_id])->first();
            }
            return response()->json([
                'data'=>$cat->category_name,
                'title'=>$setting->home_title
            ]);
        }else{
            return response()->json([
                'data'=>false,
                'title'=>$setting->home_title
            ]);
        }

    }
    public function RelatedProduct($productCode){
        $productCheck = DB::table('product_attributes')->where(['sku'=>$productCode])->select('id')->count();
        if($productCheck >0){
            $prod = DB::table('product_attributes')->where(['sku'=>$productCode])->select('product_id')->first();
            $category_id = DB::table('products')->where(['id'=>$prod->product_id])->select('category_id')->first();
        }else{
            $category_id = DB::table('products')->where(['code'=>$productCode])->select('category_id')->first();
        }
        $categoryProduct = DB::table('products')->where(['category_id'=>$category_id->category_id])->select('type','product_name','id','product_desc','description','stock','code','selling_price','lowest_price','highest_price','min_order')->get()->take(10);
        foreach($categoryProduct as $p){
            $productImages[] = DB::table('images')->where(['product_id'=>$p->id])->select('name')->first();
        }
        return response()->json([
            'product'=>$categoryProduct,
            'image'=>$productImages
        ]);
    }
    public function ProductDetailPage($productCode){
        $productFirstCount = DB::table('products')->where(['code'=>$productCode])->select('id')->count();
        if($productFirstCount == 0){
            return response()->json([
                'data'=>false,
            ]);
        }
        $productFirst = DB::table('products')->where(['code'=>$productCode])->select('type','product_name','id','product_desc','description','stock','code','selling_price','lowest_price','highest_price','min_order')->first();
        $product_leads = DB::table('product_leads')->where(['product_id'=>$productFirst->id])->select('name','value')->get();
        $product_specifications = DB::table('product_specifications')->where(['product_id'=>$productFirst->id])->select('name','value')->get();
        $productImages = DB::table('images')->where(['product_id'=>$productFirst->id])->select('name')->get();
        $productTermsConditions = DB::table('terms_conditions')->select('product_order_terms_condition')->first();
        if($productFirst->type == 'variable'){
            $product_color_variant = DB::table('product_attributes')->where(['product_id'=>$productFirst->id])->select('color','image')->get();
            $productSizes = DB::table('product_attributes')->where(['product_id'=>$productFirst->id])->where(['color'=>$product_color_variant[0]->color])->select('image','size')->get();
            return response()->json([
                'data'=>true,
                'product'=>$productFirst,
                'productVariant'=>$product_color_variant,
                'productLeads'=>$product_leads,
                'productSpecifications'=>$product_specifications,
                'productSizes'=>$productSizes,
                'productImages'=>$productImages,
                'productTermsConditions'=>$productTermsConditions
            ]);
        }else{
            
            return response()->json([
                'data'=>true,
                'product'=>$productFirst,
                'productLeads'=>$product_leads,
                'productSpecifications'=>$product_specifications,
                'productImages'=>$productImages,
                'productTermsConditions'=>$productTermsConditions
            ]);
        }
    }
    public function ProductDetailPageProductDetail($productId, $name){
        $productSizes = DB::table('product_attributes')->where(['product_id'=>$productId])->where(['color'=>$name])->select('image','size','selling_price','lowest_price','highest_price','stock','sku')->get();
        return response()->json([
            'productSizes'=>$productSizes,
        ]);
    }
    public function ProductWiseSizePrice(Request $request){
        $productSizes = DB::table('product_attributes')->where(['size'=>$request->size])->where(['product_id'=>$request->productId])->where(['color'=>$request->color])->select('image','size','selling_price','lowest_price','highest_price','stock','sku')->first();
        return response()->json([
            'productSizes'=>$productSizes,
        ]);
    }
    public function HotSellingProduct(){
        $products = DB::table('products')->orderBy('total_order','DESC')->select('type','product_name','id','product_desc','description','stock','code','selling_price','lowest_price','highest_price','min_order')->get()->take(10);
        foreach($products as $p){
            $productImages[] = DB::table('images')->where(['product_id'=>$p->id])->select('name')->first();
        }
        return response()->json([
            'hot_products'=>$products,
            'hot_productImages'=>$productImages
        ]);
    }
}
