<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
use App\Models\Quote;
use Carbon\Carbon;
use Storage;
class QuoteController extends Controller
{
    public function QuoteFormPage($token, $sku){
        $productCheck = DB::table('product_attributes')->where(['sku'=>$sku])->count();
        if($productCheck > 0){
            $product = DB::table('product_attributes')->where(['sku'=>$sku])->select('lowest_price','highest_price','size','color','product_id')->first();
            $product_name = DB::table('products')->where(['id'=>$product->product_id])->select('product_name')->first()->product_name;
            $product_image =DB::table('product_attributes')->where(['sku'=>$sku])->select('image')->first()->image;
        }else{
            $product = DB::table('products')->where(['code'=>$sku])->select('lowest_price','highest_price','id')->first();
            $product_name = DB::table('products')->where(['id'=>$product->id])->select('product_name')->first()->product_name;
            $product_image =DB::table('images')->where(['product_id'=>$product->id])->select('name')->first()->name;
        }
        return response()->json([
            'success'=>true,
            'product'=>$product,
            'product_name'=>$product_name,
            'product_image'=>$product_image,
        ]);
    }
    public function AddQuotePost(Request $request, $sku){
        $quote = new Quote;
        if($sku != 'no'){
            $quote->product_sku = $sku;
            $checkProduct = DB::table('product_attributes')->where(['sku'=>$sku])->select('id')->count();
            if($checkProduct > 0){
                $produddcts = DB::table('product_attributes')->where(['sku'=>$sku])->select('id','image','color','size')->first();
                $quote->image = $produddcts->image;
                $quote->color = $produddcts->color;
                $quote->size = $produddcts->size;
            }else{
                $produddcts = DB::table('products')->where(['code'=>$sku])->select('id')->first();
                $imageDD = DB::table('images')->where(['product_id'=>$produddcts->id])->first();
                $quote->image = $imageDD->name;
            }
        }
        $quote->name = $request->name;
        $quote->product_name = $request->product_name;
        if($sku == 'no'){
            $quote->custom = 1;
        }
        $quote->company_name = $request->company_name;
        $quote->contact_number = $request->contact_number;
        $quote->email = $request->email;
        $quote->address = $request->address;
        $quote->note = $request->note;
        $quote->quantity = $request->quantity;
        $quote->date_time = Carbon::now()->format('Y-m-d g:i A');
        if($request->image){
            $img_path = 'image/quota_file/'.''.$request->company_name.''.$request->fileName;
            Storage::disk('public')->put($img_path, file_get_contents($request->image));
            $quote->file_image = $request->company_name.''.$request->fileName;
        }
        $quote->save();
        $setting = DB::table('settings')->select('sms_api_key','sms_sender_id','web_name','sms_url')->first();
        $api_key = $setting->sms_api_key;
        $to = $request->contact_number;
        $from = $setting->sms_sender_id;
        $sms = "Your Quote is request successfull. Your Quotation ID : $quote->id. WholeSaleBagBd";
        $url = $setting->sms_url;
        $data= array(
        'api_key'=>"$api_key",
        'from'=>"$from",
        'to'=>"+880$to",
        'sms'=>"$sms",
        ); // Add parameters in key value
        $ch = curl_init(); // Initialize cURL
        curl_setopt($ch, CURLOPT_URL,$url);
        curl_setopt($ch, CURLOPT_ENCODING, '');
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $smsresult = curl_exec($ch);
        return response()->json([
            'data'=>$sku,
        ]);
    }
    public function UploadQuotaFormFile(Request $request){
        $img_path = 'image/quota_file/'.$request->fileName;
        Storage::disk('public')->put($img_path, file_get_contents($request->image));
        return response()->json([
            'data'=>true,
        ]);
    }
}
